IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_AppEve_Acred_Validar]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_AppEve_Acred_Validar] 
END
GO

CREATE PROCEDURE [dbo].[CP_AppEve_Acred_Validar] @pId_Trans INT /*Inscripcion*/
AS

DECLARE @Titulo				VARCHAR(50)
DECLARE @Mensaje			VARCHAR(100)
DECLARE @Flag_Habilitado	TINYINT
DECLARE @Id_Estado_Cbte		TINYINT

DECLARE @Id_Cliente			INT
DECLARE @Id_Lista_Precio	SMALLINT

SET @Id_Cliente = ISNULL((SELECT Id_Cliente FROM Cbtes WHERE Id_Trans = @pId_Trans),0)

SELECT	@Id_Cliente		= ISNULL(Id_Cliente, 0),
		@Id_Estado_Cbte	= ISNULL(Id_Estado_Cbte, 0)
		FROM Cbtes WHERE Id_Trans = @pId_Trans

SET @Id_Lista_Precio = ISNULL((SELECT Id_Lista_Precio FROM Clientes WHERE Id_Cliente = @Id_Cliente),0)

IF @Id_Lista_Precio NOT IN (4,5) AND @Id_Estado_Cbte<>2
BEGIN
	SET @Flag_Habilitado	= 0
	SET @Titulo				= 'Acreditacin en Revisin'
	SET @Mensaje			= 'Por favor acercase al sector de administracin.'
END  
ELSE   
BEGIN 
	SET @Flag_Habilitado	= 1
	SET @Titulo				= ''
	SET @Mensaje			= ''
END

SELECT	@pId_Trans			AS Id_Trans,
		@Flag_Habilitado	AS Flag_Habilitado,
		@Titulo				AS Titulo,
		@Mensaje			AS Mensaje
		



